
* =================================
* Replication File for: Euchner and Frech 2020: Candidate Selection and Parliamentary Activity in the EU's Mulit-Level System: Opening a Black-Box
* DOI for relating Publication: 10.17645/pag.v8i1.2553
* File for Analyses
* Last modified: 12.12.2019


* Data files used: EuchnerFrech_2020_data_anonymized_PaG.dta
* Data output: none
* ================================


* Set up STATA
version 14
set more off, permanently
clear
clear matrix


* cd""
*load dataset 
use EuchnerFrech_2020_data_anonymized_PaG2.dta, replace


******************************
*Models - ML - Table 2 in the paper
******************************
 xtmixed  percAllSpeeches exclSelection  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr || Country:   || np:

 xtmixed  percAllWrittenQuestions exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country: || np:
 
 xtmixed  percAllOpinions exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:

 xtmixed   percAllReportsDrafted exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:


******************************
*Models - ML - Table 3 in the paper (effects of nomination and decision separate)
******************************

 xtmixed  percAllSpeeches FR15_nomination  FR15_decisionS closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr || Country:   || np:

 xtmixed  percAllWrittenQuestions FR15_nomination FR15_decisionS closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country: || np:

 xtmixed  percAllOpinions FR15_nomination  FR15_decisionS closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:

 xtmixed   percAllReportsDrafted FR15_nomination  FR15_decisionS closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:
 

******************************
*Models in the Online Supplementary Material

******************************
*Models - Fractional Logit - Table A4
******************************

  glm  percAllSpeeches2 exclSelection  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr, link(logit) family(binomial) robust

  glm  percAllWrittenQuestions2 exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr,  link(logit) family(binomial) robust

  glm  percAllOpinions2 exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr,  link(logit) family(binomial) robust

  glm   percAllReportsDrafted2 exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr,  link(logit) family(binomial) robust
 

 *Different IVs (Robustness Checks) - Table A5
******************************
  xtmixed  percAllSpeeches FR15_nominationExclD FR15_decisionSExclD  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr || Country:   || np:

  xtmixed  percAllWrittenQuestions FR15_nominationExclD FR15_decisionSExclD closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country: || np:

  xtmixed  percAllOpinions FR15_nominationExclD FR15_decisionSExclD  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:

  xtmixed   percAllReportsDrafted FR15_nominationExclD FR15_decisionSExclD closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:
 
  
*DV2 (with individual members left out) - Table A6
******************************
  xtmixed  percAllSpeeches FR15_nominationExclD2 FR15_decisionSExclD closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr || Country:   || np:

 xtmixed  percAllWrittenQuestions FR15_nominationExclD2 FR15_decisionSExclD closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country: || np:

 xtmixed  percAllOpinions FR15_nominationExclD2 FR15_decisionSExclD  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:

  xtmixed   percAllReportsDrafted FR15_nominationExclD2 FR15_decisionSExclD closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:
 

*Different DV - Table A7
******************************

  xtmixed  ALLpercAllSpeeches exclSelection  closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr || Country:   || np:

  xtmixed  ALLpercAllWrittenQuestions exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country: || np:

  xtmixed  ALLpercAllOpinions exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:

  xtmixed   ALLpercAllReportsDrafted exclSelection closedlist shareInOpp eurosceptic ptysize female CommitteePower CommitteeChair chairXPower  EPLeadership  ParticipationinRCV  H_termno age epglr  || Country:   || np:
 
 
